/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.DefenseEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.mojang.math.Axis;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.init.ModEntities;

public class HkGMGEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
CannonEntity,
DefenseEntity {
    public static Consumer<MobileVehicleEntity> fireSound = vehicle -> {};
    public static final EntityDataAccessor<Integer> ANIM_TIME = SynchedEntityData.m_135353_(HkGMGEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> GUN_ROTATE = SynchedEntityData.m_135353_(HkGMGEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(HkGMGEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(HkGMGEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(HkGMGEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Integer> FIRE_TIME = SynchedEntityData.m_135353_(HkGMGEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean wasFiring = false;
    public int changeTargetTimer = 60;
    public float gunRot;
    public float gunRotO;

    public HkGMGEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<HkGMGEntity>)((EntityType)ModEntities.HK_GMG.get()), world);
    }

    public HkGMGEntity(EntityType<HkGMGEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_TIME, (Object)0);
        this.f_19804_.m_135372_(GUN_ROTATE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"none");
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(FIRE_TIME, (Object)0);
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage(((Double)VehicleConfig.HPJ11_DAMAGE.get()).floatValue()).explosionDamage(((Double)VehicleConfig.HPJ11_EXPLOSION_DAMAGE.get()).floatValue()).explosionRadius(((Double)VehicleConfig.HPJ11_EXPLOSION_RADIUS.get()).floatValue()).aa(true).icon(Mod.loc((String)"textures/screens/vehicle_weapon/cannon_30mm.png"))}};
    }

    public static HkGMGEntity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        HkGMGEntity entity = new HkGMGEntity((EntityType<HkGMGEntity>)castedEntityType, world);
        return entity;
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(2.0 + 0.75 * ClientMouseHandler.custom3pDistanceLerp, 0.75, 0.0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AnimTime", ((Integer)this.f_19804_.m_135370_(ANIM_TIME)).intValue());
        compound.m_128379_("Active", ((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ANIM_TIME, (Object)compound.m_128451_("AnimTime"));
        this.f_19804_.m_135381_(ACTIVE, (Object)compound.m_128471_("Active"));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 1.0f) * damage.floatValue()));
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(0.0, Math.min((double)super.m_20184_().f_82480_, (double)0.0), 0.0);
    }

    public void m_6075_() {
        if (!this.wasFiring && this.isFiring() && this.m_9236_().m_5776_()) {
            fireSound.accept((MobileVehicleEntity)this);
        }
        this.wasFiring = this.isFiring();
        this.gunRotO = this.getGunRot();
        super.m_6075_();
        if ((Integer)this.f_19804_.m_135370_(ANIM_TIME) > 0) {
            this.f_19804_.m_135381_(ANIM_TIME, (Object)((Integer)this.f_19804_.m_135370_(ANIM_TIME) - 1));
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.handleAmmo();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.fireInputDown && ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFire) {
                this.vehicleShoot((LivingEntity)player, 0);
            }
        }
        this.f_19804_.m_135381_(GUN_ROTATE, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(GUN_ROTATE)).floatValue() * 0.8f));
        this.setGunRot(this.getGunRot() + ((Float)this.f_19804_.m_135370_(GUN_ROTATE)).floatValue());
        if ((Integer)this.f_19804_.m_135370_(FIRE_TIME) > 0) {
            this.f_19804_.m_135381_(FIRE_TIME, (Object)((Integer)this.f_19804_.m_135370_(FIRE_TIME) - 1));
        }
        this.lowHealthWarning();
    }

    private void handleAmmo() {
        if (this.hasItem((Item)ModItems.CREATIVE_AMMO_BOX.get())) {
            this.f_19804_.m_135381_(AMMO, (Object)9999);
        } else {
            this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)ModItems.SMALL_SHELL.get()));
        }
    }

    public boolean isFiring() {
        return (Integer)this.f_19804_.m_135370_(FIRE_TIME) > 0;
    }

    public float getGunRot() {
        return this.gunRot;
    }

    public void setGunRot(float pGunRot) {
        this.gunRot = pGunRot;
    }

    public void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.m_14175_((double)(this.serverYRot - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.serverXRot - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        callback.m_20372_(passenger, this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float g = Mth.m_14036_((float)f, (float)-90.0f, (float)90.0f);
        entity.f_19859_ += g - f;
        entity.m_146922_(entity.m_146908_() + g - f);
        entity.m_5616_(entity.m_146908_());
        entity.m_5618_(this.m_146908_());
    }

    public Vec3 driverPos(float ticks) {
        Matrix4f transform = this.getVehicleTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getBarrelTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public void vehicleShoot(LivingEntity living, int type) {
        if (this.cannotFire) {
            return;
        }
        boolean hasCreativeAmmo = InventoryTool.hasCreativeAmmoBox((Entity)this.m_146895_()) || this.hasItem((Item)ModItems.CREATIVE_AMMO_BOX.get());
        this.f_19804_.m_135381_(FIRE_TIME, (Object)Math.min((int)((Integer)this.f_19804_.m_135370_(FIRE_TIME) + 3), (int)5));
        SmallCannonShellEntity entityToSpawn = ((SmallCannonShellWeapon)this.getWeapon(0)).create(living);
        Matrix4f transform = this.getBarrelTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.2f, 0.5f);
        entityToSpawn.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        entityToSpawn.m_6686_(this.m_20154_().f_82479_, this.m_20154_().f_82480_, this.m_20154_().f_82481_, 20.0f, 0.25f);
        this.m_9236_().m_7967_((Entity)entityToSpawn);
        this.f_19804_.m_135381_(GUN_ROTATE, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(GUN_ROTATE)).floatValue() + 0.5f));
        this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 2));
        this.f_19804_.m_135381_(ANIM_TIME, (Object)1);
        if (hasCreativeAmmo) {
            return;
        }
        this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
    }

    public float shootingVolume() {
        return (float)((Integer)this.f_19804_.m_135370_(FIRE_TIME)).intValue() * 0.4f;
    }

    public float shootingPitch() {
        return 0.8f + (float)((Integer)this.f_19804_.m_135370_(FIRE_TIME)).intValue() * 0.1f;
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, -3.375E-4f, 0.859375f, -8.25E-4f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_())));
        return transformV;
    }

    public void travel() {
        Entity passenger = this.m_146895_();
        if (passenger != null) {
            float diffY = Mth.m_14177_((float)(passenger.m_6080_() - this.m_146908_()));
            float diffX = Mth.m_14177_((float)(passenger.m_146909_() - this.m_146909_()));
            this.turretTurnSound(diffX, diffY, 0.95f);
            this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.9f * diffY), (float)-20.0f, (float)20.0f));
            this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + Mth.m_14036_((float)(0.9f * diffX), (float)-15.0f, (float)15.0f)), (float)-90.0f, (float)32.5f));
        }
    }

    protected void clampRotation(Entity entity) {
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)-90.0f, (float)32.5f);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int mainGunRpm(LivingEntity living) {
        if (this.getWeaponIndex(0) == 0) {
            return 10;
        }
        return 0;
    }

    public boolean canShoot(LivingEntity living) {
        return false;
    }

    public int getAmmoCount(LivingEntity living) {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    public boolean hidePassenger(int index) {
        return true;
    }

    public int zoomFov() {
        return 11;
    }

    public int getWeaponHeat(LivingEntity living) {
        return (Integer)this.f_19804_.m_135370_(HEAT);
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        if (this.m_146895_() != null) {
            return this.m_146895_().m_20252_(pPartialTicks);
        }
        return super.getBarrelVector(pPartialTicks);
    }

    public ResourceLocation getVehicleIcon() {
        return Mod.loc((String)"textures/vehicle_icon/hpj_11_icon.png");
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.25 : 0.3;
    }

    public boolean isEnclosed(int index) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (zoom) {
                return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, this.driverZoomPos((float)partialTicks).f_82480_, this.driverZoomPos((float)partialTicks).f_82481_);
            }
            return new Vec3(this.driverPos((float)partialTicks).f_82479_, this.driverPos((float)partialTicks).f_82480_, this.driverPos((float)partialTicks).f_82481_);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return true;
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/defense.png");
    }
}

